/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.alexscaves;

import com.tterrag.registrate.builders.NoConfigBuilder;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import dev.xkmc.l2complements.init.data.TagGen;
import dev.xkmc.modulargolems.compat.materials.alexscaves.modifier.AtomicBoostedEffect;
import dev.xkmc.modulargolems.compat.materials.alexscaves.modifier.AtomicFuelingModifier;
import dev.xkmc.modulargolems.compat.materials.alexscaves.modifier.CandyShootModifier;
import dev.xkmc.modulargolems.compat.materials.alexscaves.modifier.CandyStickModifier;
import dev.xkmc.modulargolems.compat.materials.alexscaves.modifier.DummyConsumer;
import dev.xkmc.modulargolems.compat.materials.alexscaves.modifier.FreeMoveModifier;
import dev.xkmc.modulargolems.compat.materials.alexscaves.modifier.PolarizeModifier;
import dev.xkmc.modulargolems.compat.materials.alexscaves.modifier.RadiationModifier;
import dev.xkmc.modulargolems.compat.materials.alexscaves.modifier.ReformationModifier;
import dev.xkmc.modulargolems.content.item.upgrade.CraftMaterialItem;
import dev.xkmc.modulargolems.content.item.upgrade.RepairMaterialItem;
import dev.xkmc.modulargolems.init.ModularGolems;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import dev.xkmc.modulargolems.init.registrate.GolemModifiers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModList;

public class ACCompatRegistry {
    public static final RegistryEntry<CandyStickModifier> STICKY = GolemModifiers.reg("sticky_caramel", CandyStickModifier::new, "Put molten caramel on attack targets");
    public static final RegistryEntry<CandyShootModifier> SHOOT = GolemModifiers.reg("gum_shooter", CandyShootModifier::new, "Shoot gumballs at targets dealing %s damage");
    public static final RegistryEntry<FreeMoveModifier> FREE = GolemModifiers.reg("free_movement", FreeMoveModifier::new, "Golem will not be stuck by blocks or caramel");
    public static final RegistryEntry<PolarizeModifier> POLARIZE = GolemModifiers.reg("polarize", PolarizeModifier::new, "Pull enemies in melee mode and push enemies away in ranged/standing mode, deal %s electrical damage constantly.");
    public static final RegistryEntry<ReformationModifier> REFORMATION = GolemModifiers.reg("reformation", ReformationModifier::new, "Consume iron ingot to gain %s absorption and heal %s. Golem may hold at most %s absorption");
    public static final RegistryEntry<RadiationModifier> RADIATION = GolemModifiers.reg("radiation", RadiationModifier::new, "Inflict %s to attack targets. Damage to radiated target increase by %s per radiation level.");
    public static final RegistryEntry<AtomicFuelingModifier> ATOMIC = GolemModifiers.reg("atomic_fueling", AtomicFuelingModifier::new, "Consume [%s] to heal %s HP, and boost attack and speed by %s for %s seconds. Makes golem immune to irradiated effect.");
    public static final ItemEntry<RepairMaterialItem> REPAIR_CANDY = GolemItems.item("alexscaves", "candy_mixture", RepairMaterialItem::new);
    public static final ItemEntry<RepairMaterialItem> REPAIR_MAGNETIC;
    public static final ItemEntry<CraftMaterialItem> CRAFT_CANDY;
    public static final ItemEntry<CraftMaterialItem> CRAFT_MAGNETIC;
    public static final ItemEntry<Item> CRAFT_NUCLEAR;
    public static final RegistryEntry<AtomicBoostedEffect> EFF_ATOMIC;
    public static final ItemEntry<DummyConsumer> DUMMY_IRON;
    public static final ItemEntry<DummyConsumer> DUMMY_URANIUM;

    private static <T extends MobEffect> RegistryEntry<T> genEffect(String name, NonNullSupplier<T> sup, String desc) {
        return ((NoConfigBuilder)ModularGolems.REGISTRATE.effect(name, sup, desc).lang(MobEffect::m_19481_)).register();
    }

    public static void register() {
        if (ModList.get().isLoaded("l2complements")) {
            MGTagGen.OPTIONAL_EFF.add(e -> e.addTag(TagGen.SKILL_EFFECT).m_176839_(EFF_ATOMIC.getId()));
        }
    }

    static {
        CRAFT_CANDY = GolemItems.item("alexscaves", "candy_construct", CraftMaterialItem::new);
        REPAIR_MAGNETIC = GolemItems.item("alexscaves", "magnetic_alloy", RepairMaterialItem::new);
        CRAFT_MAGNETIC = GolemItems.item("alexscaves", "magnetic_construct", CraftMaterialItem::new);
        CRAFT_NUCLEAR = GolemItems.item("alexscaves", "nuclear_construct", Item::new);
        EFF_ATOMIC = ACCompatRegistry.genEffect("atomic_boost", () -> new AtomicBoostedEffect(MobEffectCategory.BENEFICIAL, -1), "Increase golem attack damage and movement speed");
        DUMMY_IRON = ModularGolems.REGISTRATE.item("dummy_iron_consumer", p -> new DummyConsumer((TagKey<Item>)Tags.Items.INGOTS_IRON)).model((ctx, pvd) -> pvd.withExistingParent("item/" + ctx.getName(), "block/air")).removeTab(GolemItems.TAB.getKey()).register();
        DUMMY_URANIUM = ModularGolems.REGISTRATE.item("dummy_uranium_consumer", p -> new DummyConsumer((TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation("forge", "nuggets/uranium")))).model((ctx, pvd) -> pvd.withExistingParent("item/" + ctx.getName(), "block/air")).removeTab(GolemItems.TAB.getKey()).register();
    }
}

